<?php
/**
 * Cookie condition logic swiftly crafted.
 *
 * @since ??
 *
 * @package     Divi
 * @sub-package Builder
 */

namespace Module\Field\DisplayConditions;

/**
 * Cookie Condition Trait.
 */
trait CookieCondition {

	/**
	 * Processes "Cookie" condition.
	 *
	 * @since ??
	 *
	 * @param  array $condition_settings Containing all settings of the condition.
	 *
	 * @return boolean Condition output.
	 */
	protected function _process_cookie_condition( $condition_settings ) {
		$display_rule           = isset( $condition_settings['cookieDisplay'] ) ? $condition_settings['cookieDisplay'] : 'cookieExists';
		$cookie_name            = isset( $condition_settings['cookieName'] ) ? $condition_settings['cookieName'] : '';
		$cookie_value           = isset( $condition_settings['cookieValue'] ) ? $condition_settings['cookieValue'] : '';
		$is_cookie_set          = ( isset( $_COOKIE[ $cookie_name ] ) ) ? true : false;
		$is_cookie_value_equals = ( isset( $_COOKIE[ $cookie_name ] ) ) ? $cookie_value === $_COOKIE[ $cookie_name ] : false;

		switch ( $display_rule ) {
			case 'cookieExists':
				return $is_cookie_set;

			case 'cookieDoesNotExist':
				return ! $is_cookie_set;

			case 'cookieValueEquals':
				return $is_cookie_value_equals;

			case 'cookieValueDoesNotEqual':
				return ! $is_cookie_value_equals;

			default:
				return false;
		}
	}

}
